/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.doors;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.entities.wallcap.WallCapAssetDictionary;
import technology.rocketjump.undermount.assets.entities.wallcap.model.WallCapAsset;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.doors.Doorway;
import technology.rocketjump.undermount.doors.DoorwayOrientation;
import technology.rocketjump.undermount.doors.DoorwaySize;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.entities.behaviour.furniture.DoorBehaviour;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityFactory;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.DoorwayEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.MapMessageHandler;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.misc.VectorUtils;

@Singleton
public class DoorwayMessageHandler
implements GameContextAware,
Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final WallCapAssetDictionary wallCapAssetDictionary;
    private final FurnitureEntityFactory furnitureEntityFactory;
    private final FurnitureTypeDictionary furnitureTypeDictionary;
    private final FurnitureLayoutDictionary furnitureLayoutDictionary;
    private final ItemEntityFactory itemEntityFactory;
    private GameContext gameContext;

    @Inject
    public DoorwayMessageHandler(MessageDispatcher messageDispatcher, WallCapAssetDictionary wallCapAssetDictionary, FurnitureEntityFactory furnitureEntityFactory, FurnitureTypeDictionary furnitureTypeDictionary, FurnitureLayoutDictionary furnitureLayoutDictionary, ItemEntityFactory itemEntityFactory) {
        this.messageDispatcher = messageDispatcher;
        this.wallCapAssetDictionary = wallCapAssetDictionary;
        this.furnitureEntityFactory = furnitureEntityFactory;
        this.furnitureTypeDictionary = furnitureTypeDictionary;
        this.furnitureLayoutDictionary = furnitureLayoutDictionary;
        this.itemEntityFactory = itemEntityFactory;
        messageDispatcher.addListener(this, 801);
        messageDispatcher.addListener(this, 809);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 801: {
                return this.handle((DoorwayPlacementMessage)msg.extraInfo);
            }
            case 809: {
                GridPoint2 location = (GridPoint2)msg.extraInfo;
                MapTile targetTile = this.gameContext.getAreaMap().getTile(location);
                if (targetTile != null && targetTile.hasDoorway()) {
                    Doorway doorway = targetTile.getDoorway();
                    FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)doorway.getDoorEntity().getPhysicalEntityComponent().getAttributes();
                    List<QuantifiedItemType> constructionRequirements = attributes.getFurnitureType().getRequirements().get((Object)attributes.getPrimaryMaterialType());
                    if (constructionRequirements != null && !constructionRequirements.isEmpty()) {
                        QuantifiedItemType quantifiedItemType = constructionRequirements.get(0);
                        ItemEntityAttributes itemAttributes = new ItemEntityAttributes(this.gameContext.getRandom().nextLong());
                        itemAttributes.setItemType(quantifiedItemType.getItemType());
                        itemAttributes.setQuantity(Math.max(1, quantifiedItemType.getQuantity() / 2));
                    }
                    this.messageDispatcher.dispatchMessage(322, new EntityMessage(doorway.getDoorEntity().getId()));
                    targetTile.setDoorway(null);
                    MapMessageHandler.updateCell(targetTile, this.gameContext);
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private boolean handle(DoorwayPlacementMessage message) {
        GridPoint2 doorwayLocation = message.getTilePosition();
        MapTile targetTile = this.gameContext.getAreaMap().getTile(doorwayLocation);
        Doorway doorway = new Doorway();
        doorway.setOrientation(message.getOrientation());
        doorway.setDoorwayMaterialType(message.getDoorwayMaterial().getMaterialType());
        doorway.setDoorwaySize(message.getDoorwaySize());
        doorway.setTileLocation(doorwayLocation);
        targetTile.setDoorway(doorway);
        GameMaterial attachedWallMaterial = null;
        if (message.getOrientation().equals((Object)DoorwayOrientation.NORTH_SOUTH)) {
            Entity southCap = this.buildWallCap(doorwayLocation.cpy().add(0, -1), doorway, EntityAssetOrientation.DOWN, -0.484375f);
            doorway.getWallCapEntities().add(southCap);
            attachedWallMaterial = this.getAttachedWallMaterial(southCap);
        } else {
            Entity westCap = this.buildWallCap(doorwayLocation.cpy().add(-1, 0), doorway, EntityAssetOrientation.LEFT, 0.5f);
            Entity eastCap = this.buildWallCap(doorwayLocation.cpy().add(1, 0), doorway, EntityAssetOrientation.RIGHT, 0.5f);
            doorway.getWallCapEntities().add(westCap);
            doorway.getWallCapEntities().add(eastCap);
            attachedWallMaterial = this.getAttachedWallMaterial(westCap);
        }
        doorway.setFrameEntity(this.createFrameEntity(message, attachedWallMaterial));
        doorway.setDoorEntity(this.createDoorEntity(message));
        return true;
    }

    private Entity createFrameEntity(DoorwayPlacementMessage message, GameMaterial attachedWallMaterial) {
        FurnitureEntityAttributes attributes = new FurnitureEntityAttributes(SequentialIdGenerator.nextId());
        attributes.setPrimaryMaterialType(message.getDoorwayMaterial().getMaterialType());
        if (message.getDoorwayMaterial().getMaterialType().equals((Object)attachedWallMaterial.getMaterialType())) {
            attributes.getMaterials().put(attachedWallMaterial.getMaterialType(), attachedWallMaterial);
        } else {
            attributes.getMaterials().put(message.getDoorwayMaterial().getMaterialType(), message.getDoorwayMaterial());
        }
        attributes.setFurnitureType(this.furnitureTypeDictionary.getByName(this.selectFrameFurnitureTypeName(message)));
        attributes.setCurrentLayout(this.pickFurnitureLayout(message));
        Entity entity = this.furnitureEntityFactory.create(attributes, message.getTilePosition(), null, this.gameContext.getAreaMap());
        entity.getLocationComponent().setWorldPosition(VectorUtils.toVector(message.getTilePosition()).add(0.0f, -0.5f), false);
        return entity;
    }

    private Entity createDoorEntity(DoorwayPlacementMessage message) {
        FurnitureEntityAttributes attributes = new FurnitureEntityAttributes(SequentialIdGenerator.nextId());
        attributes.setPrimaryMaterialType(message.getDoorwayMaterial().getMaterialType());
        attributes.getMaterials().put(message.getDoorwayMaterial().getMaterialType(), message.getDoorwayMaterial());
        attributes.setFurnitureType(this.furnitureTypeDictionary.getByName(this.selectDoorFurnitureTypeName(message)));
        attributes.setCurrentLayout(this.pickFurnitureLayout(message));
        Entity entity = this.furnitureEntityFactory.create(attributes, message.getTilePosition(), new DoorBehaviour(), this.gameContext.getAreaMap());
        this.gameContext.getEntityStore().add(entity, this.gameContext.getAreaMap());
        entity.getLocationComponent().setWorldPosition(VectorUtils.toVector(message.getTilePosition()).add(0.0f, 0.484375f), false);
        return entity;
    }

    private Entity buildWallCap(GridPoint2 wallTileLocation, Doorway doorway, EntityAssetOrientation assetOrientation, float positionYOffset) {
        DoorwayEntityAttributes attributes = new DoorwayEntityAttributes(SequentialIdGenerator.nextId());
        MapTile tileAtPosition = this.gameContext.getAreaMap().getTile(wallTileLocation);
        if (!tileAtPosition.hasWall()) {
            System.err.println("No wall in expected location for doorway");
            return null;
        }
        attributes.setAttachedWallMaterial(tileAtPosition.getWall().getMaterial());
        attributes.setAttachedWallType(tileAtPosition.getWall().getWallType());
        attributes.setOrientation(assetOrientation);
        Entity wallCapEntity = this.furnitureEntityFactory.create(attributes, doorway.getTileLocation(), null, this.gameContext.getAreaMap());
        WallCapAsset baseAsset = this.wallCapAssetDictionary.getMatching(doorway, attributes);
        wallCapEntity.getPhysicalEntityComponent().setBaseAsset(baseAsset);
        wallCapEntity.getPhysicalEntityComponent().getTypeMap().put(baseAsset.getType(), baseAsset);
        wallCapEntity.getLocationComponent().setOrientation(assetOrientation);
        wallCapEntity.getLocationComponent().setWorldPosition(VectorUtils.toVector(doorway.getTileLocation()).add(0.0f, positionYOffset), false);
        tileAtPosition.update(this.gameContext.getAreaMap().getNeighbours(wallTileLocation), this.gameContext.getAreaMap().getVertices(wallTileLocation.x, wallTileLocation.y));
        return wallCapEntity;
    }

    private FurnitureLayout pickFurnitureLayout(DoorwayPlacementMessage message) {
        if (message.getDoorwaySize().equals((Object)DoorwaySize.SINGLE)) {
            if (message.getOrientation().equals((Object)DoorwayOrientation.EAST_WEST)) {
                return this.furnitureLayoutDictionary.getByName("1x1EW");
            }
            return this.furnitureLayoutDictionary.getByName("1x1NS");
        }
        throw new NotImplementedException("Not yet implemented non-single doorway sizes");
    }

    private String selectFrameFurnitureTypeName(DoorwayPlacementMessage message) {
        if (message.getDoorwaySize().equals((Object)DoorwaySize.SINGLE)) {
            return "SINGLE_DOOR_FRAME";
        }
        throw new NotImplementedException("Not yet implemented non-single doorway sizes");
    }

    private String selectDoorFurnitureTypeName(DoorwayPlacementMessage message) {
        if (message.getDoorwaySize().equals((Object)DoorwaySize.SINGLE)) {
            return "SINGLE_DOOR";
        }
        throw new NotImplementedException("Not yet implemented non-single doorway sizes");
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }

    private GameMaterial getAttachedWallMaterial(Entity wallCapEntity) {
        DoorwayEntityAttributes attributes = (DoorwayEntityAttributes)wallCapEntity.getPhysicalEntityComponent().getAttributes();
        return attributes.getAttachedWallMaterial();
    }
}

